/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.rbf.BusyException;
import com.ibm.hwmca.fw.rbf.HandlerNotRegisteredException;
import com.ibm.hwmca.fw.rbf.RbfErrorDetail;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.rbf.impl.PrepareReply;
import com.ibm.hwmca.fw.rbf.impl.RbfMsg;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.util.Trace;

class PrepareMsg
implements RbfMsg {
    private static final String TRACE_MASKT = "XRBFPMST";
    private static final String TRACE_MASKF = "XRBFPMSF";
    private static final String TRACE_MASKD = "XRBFPMSD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-PrepMsg");
    private static final long serialVersionUID = -814061558574308340L;
    private RbfRequestId requestId;
    private byte[] requestEncoding;

    PrepareMsg(RbfRequest request) throws PersistenceException {
        if (request == null) {
            throw new IllegalArgumentException("Null request specified");
        }
        this.requestId = request.getIdentifier();
        try {
            PersistenceManager pm = PersistenceManager.getPersistenceManager();
            this.requestEncoding = PersistenceManager.encode(request);
        }
        catch (PersistenceException pe) {
            String desc = pe.getClass().getName() + " encoding " + request.getClass().getName() + " " + this.requestId + ":\n" + RbfUtils.getStackTrace(pe);
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1056);
            fl.add(desc);
            fl.add(RbfUtils.getLoggingInfo(request));
            fl.log();
            throw pe;
        }
        Trace.trace(TRACE_MASKT, "<> PrepareMsg() " + this.requestId);
    }

    RbfRequestId getRequestId() {
        return this.requestId;
    }

    public RbfReply process(MachineId sender2, int protocol) {
        String desc;
        Trace.trace(TRACE_MASKT, "-> process()");
        PrepareReply reply = null;
        RbfRequest request = null;
        try {
            PersistenceManager pm = PersistenceManager.getPersistenceManager();
            request = (RbfRequest)PersistenceManager.decode(this.requestEncoding);
            RequestTrackingData trackingData = request.getTrackingData();
            trackingData.state = 4;
            trackingData.handlerCopy = true;
            trackingData.handler = null;
        }
        catch (Exception e) {
            desc = e.getClass().getName() + " decoding request " + "from " + RbfUtils.getMachineInfo(sender2) + " " + this.requestId + ":\n" + RbfUtils.getStackTrace(e);
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1057);
            fl.add(desc);
            fl.add(RbfUtils.getLoggingInfo());
            fl.log();
            RbfErrorDetail detail = new RbfErrorDetail(1057, desc);
            reply = new PrepareReply(this.requestId, 6, detail);
        }
        if (request != null) {
            try {
                RequestHandlingManager rhMgr = RequestHandlingManager.getRequestHandlingManager();
                rhMgr.provideHandling(request);
                reply = new PrepareReply(this.requestId, 0);
            }
            catch (PersistenceNotInitializedException pnie) {
                desc = RbfUtils.getStackTrace(pnie);
                Trace.trace(TRACE_MASKF, desc);
                RbfErrorDetail detail = new RbfErrorDetail(1061, desc);
                reply = new PrepareReply(this.requestId, 8);
            }
            catch (HandlerNotRegisteredException hnre) {
                reply = new PrepareReply(this.requestId, 4);
            }
            catch (BusyException be) {
                reply = new PrepareReply(this.requestId, 2);
            }
            catch (RbfException rbfe) {
                reply = new PrepareReply(this.requestId, 4);
            }
        }
        Trace.trace(TRACE_MASKT, "<- process()");
        return reply;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[PrepareMsg: reqId=" + this.requestId + "]");
        return sb.toString();
    }
}

